<?php
//~ require_once 'vfsStream/vfsStream.php';
require_once(DIR_WS_INCLUDES.'external/klarna/api/transport/xmlrpc-3.0.0.beta/lib/xmlrpc.inc');
require_once(DIR_WS_INCLUDES.'external/klarna/api/transport/xmlrpc-3.0.0.beta/lib/xmlrpc_wrappers.inc');
require_once('../Klarna.php');
require_once('jsonfileiterator.php');

/**
 * Test class for KlarnaCalc.
 * Generated by PHPUnit on 2011-02-02 at 16:59:39.
 */
class KlarnaCalcTest extends PHPUnit_Framework_TestCase {

    /**
     * @var klarnaCalc
     */
    protected $klarnaCalc;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp() {
        $this->klarnaCalc = new KlarnaCalc();
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown() {

    }

    public function dataProviderTestCalc_apr() {

        $pclassSE = new KlarnaPClass(array("1029", "777", "Description", 24, 0, 0, 9, 1, KlarnaCountry::SE, KlarnaPClass::CAMPAIGN, "1903824000"));

        $pclassNO = new KlarnaPClass(array("1029", "481", "Konto", 24, 0, 45, 22, 1, KlarnaCountry::NO, KlarnaPClass::ACCOUNT, "1903824000"));

        $specialPClass = new KlarnaPClass(array("1029", "665", "Handla nu - Betala i Mars", 2, 29, 1, 0, 1, KlarnaCountry::SE, KlarnaPClass::SPECIAL, "1903824000"));

        return array(
            array(9.38, 6000, $pclassSE, KlarnaFlags::PRODUCT_PAGE),
            array(43.44, 6000, $pclassNO, KlarnaFlags::PRODUCT_PAGE),
            array(43.44, 6000, $pclassNO, strval(KlarnaFlags::PRODUCT_PAGE)),
            array(43.44, 6000, $pclassNO, KlarnaFlags::PRODUCT_PAGE, "0")
            //array(543.03, 6000, $specialPClass, KlarnaFlags::PRODUCT_PAGE, $specialPClass->getMonths())  /** @todo Division by zero... **/
        );
    }

    /**
     * @todo testCalc_apr : The other calculator doesn't take the product or checkout page into account
     * @todo testCalc_apr : The special campaign pclasses doesn't work in the present. Not with 0 months or 0% rate
     * @dataProvider dataProviderTestCalc_apr
     *
     * <b>Flags can be either</b>:<br>
     * {@link KlarnaFlags::CHECKOUT_PAGE}<br>
     * {@link KlarnaFlags::PRODUCT_PAGE}<br>
     *
     * @param  float         $sum     The sum for the order/product.
     * @param  KlarnaPClass  $pclass  {@link KlarnaPClass PClass} used to calculate the APR.
     * @param  int           $flags   Indicates if it is the checkout or a product page.
     * @param  int           $free
     * @throws KlarnaException
     * @return float  APR in %
     */
    public function testCalc_apr($result, $sum, $pclass, $flags, $free = 0) {
        //$this->markTestIncomplete("Update test cases");
        $this->assertEquals($result, round($this->klarnaCalc->calc_apr($sum, $pclass, $flags, $free), 2));
    }

    public function dataProviderTestCalc_aprExceptions() {
        $correctPC = new KlarnaPClass(array("1029", "481", "Konto", "24", "0", "45", "22", "1", "164", "1", "1903824000"));
        $incorrectPC = new KlarnaPClass(array("1029", "481", "Konto", "24", "0", "45", "22", "1", "164", "999", "1903824000"));
        $std = new stdClass();
        return array(
            array("summa", "", "", ""),
            array(100, $std, "", ""),
            array(100, $correctPC, KlarnaFlags::CHECKOUT_PAGE, "free"),
            array(100, $correctPC, KlarnaFlags::PRODUCT_PAGE, -3),
            array(100, $correctPC, "flag", 2),
            array(100, $correctPC, 999, 2),
            array(100, $incorrectPC, KlarnaFlags::CHECKOUT_PAGE, 2),
        );
    }

    /**
     * @dataProvider dataProviderTestCalc_aprExceptions
     * @expectedException KlarnaException
     * @param float         $sum        The sum for the order/product.
     * @param KlarnaPClass  $pclass     {@link KlarnaPClass PClass} used to calculate the APR.
     * @param int           $flags      Indicates if it is the checkout or a product page.
     * @param int           $free
     */
    public function testCalc_aprExceptions($sum, $pclass, $flags, $free) {
        $this->assertNull($this->klarnaCalc->calc_apr($sum, $pclass, $flags, $free));
    }

    public function dataProviderTestTotal_credit_purchase_cost() {
        $pclassSE = new KlarnaPClass(array("1029", "777", "Description", 24, 0, 0, 9, 1, KlarnaCountry::SE, KlarnaPClass::CAMPAIGN, "1903824000"));

        $pclassNO = new KlarnaPClass(array("1029", "481", "Konto", 24, 0, 45, 22, 1, KlarnaCountry::NO, KlarnaPClass::ACCOUNT, "1903824000"));

        $specialPClass = new KlarnaPClass(array("1029", "665", "Handla nu - Betala i Mars", 2, 29, 1, 0, 1, KlarnaCountry::SE, KlarnaPClass::SPECIAL, "1903824000"));

        return array(
            array(6579, 6000, $pclassSE, KlarnaFlags::PRODUCT_PAGE),
            array(7417, 6000, $pclassNO, KlarnaFlags::PRODUCT_PAGE),
            array(6000, 6000, $specialPClass, KlarnaFlags::PRODUCT_PAGE),
            array(6000, 6000, $specialPClass, strval(KlarnaFlags::PRODUCT_PAGE))
        );
    }

    /**
     * @todo testTotal_credit_purchase_cost: The other calculator doesn't take the product or checkout page into account.
     * @dataProvider dataProviderTestTotal_credit_purchase_cost
     * @param  int|float    $result
     * @param  float        $pval      principal value
     * @param  KlarnaPClass $pclass  {@link KlarnaPClass PClass} used to calculate the APR.
     * @param  int          $flags   Indicates if it is the checkout or a product page.
     */
    public function testTotal_credit_purchase_cost($result, $pval, $pclass, $flags) {
        //$this->markTestIncomplete("Update test cases");
        $this->assertEquals(ceil($result), ceil($this->klarnaCalc->total_credit_purchase_cost($pval, $pclass, $flags)));
    }

    public function dataProviderTestTotal_credit_purchase_costException() {
        $correctPC = new KlarnaPClass(array("1029", "1029", "481", "Konto", "24", "0", "45", "22", "1", "164", "1", "1903824000"));
        $array = array();
        return array(
            array("abc", $correctPC, KlarnaFlags::CHECKOUT_PAGE),
            array("100", $array, KlarnaFlags::PRODUCT_PAGE),
            array(100, $correctPC, "abc"),
        );
    }

    /**
     * @dataProvider dataProviderTestTotal_credit_purchase_costException
     * @expectedException KlarnaException
     * @param int   $sum        The sum for the order/product in �ren/cents
     * @param int   $pclass
     * @param int   $flags      Indicates if it is the checkout or a product page.
     */
    public function testTotal_credit_purchase_costException($sum, $pclass, $flags) {
        $this->assertNull($this->klarnaCalc->total_credit_purchase_cost($sum, $pclass, $flags));
    }

    public function dataProviderTestCalc_monthly_cost() {
        $pclassSE = new KlarnaPClass(array("1029", "777", "Description", 24, 0, 0, 9, 1, KlarnaCountry::SE, KlarnaPClass::CAMPAIGN, "1903824000"));

        $pclassNO = new KlarnaPClass(array("1029", "481", "Konto", 24, 0, 45, 22, 1, KlarnaCountry::NO, KlarnaPClass::ACCOUNT, "1903824000"));

        $specialPClass = new KlarnaPClass(array("1029", "665", "Handla nu - Betala i Mars", 2, 29, 1, 0, 1, KlarnaCountry::SE, KlarnaPClass::SPECIAL, "1903824000"));

        return array(
            array(274, 6000, $pclassSE, KlarnaFlags::PRODUCT_PAGE),
            array(360, 6000, $pclassNO, KlarnaFlags::PRODUCT_PAGE),
            array(3000, 6000, $specialPClass, KlarnaFlags::PRODUCT_PAGE),
            array(3000, 6000, $specialPClass, strval(KlarnaFlags::PRODUCT_PAGE))
        );
    }

    /**
     * @todo testCalc_monthly_cost : The other calculator doesn't seem to take the product or checkout page into account.
     * @dataProvider dataProviderTestCalc_monthly_cost
     * @param  int|float    $result
     * @param  int          $sum      The sum for the order/product in �ren/cents
     * @param  KlarnaPClass $pclass
     * @param  int          $flags    Indicates if it is the checkout or a product page.
     * @param  int          $country  The Klarna country.
     * @return int|float              The monthly cost.
     */
    public function testCalc_monthly_cost($result, $sum, $pclass, $flags) {
        //$this->markTestIncomplete("Update test cases");
        $this->assertEquals(ceil($result), $this->klarnaCalc->calc_monthly_cost($sum, $pclass, $flags));
    }

    public function dataProviderTestCalc_monthly_costException() {
        $correctPC = new KlarnaPClass(array("1029", "481", "Konto", "24", "0", "45", "22", "1", "164", "1", "1903824000"));
        $array = array();
        return array(
            array("abc", $correctPC, KlarnaFlags::CHECKOUT_PAGE),
            array("100", $array, KlarnaFlags::CHECKOUT_PAGE),
            array(100, $correctPC, "abc"),
        );
    }

    /**
     * @dataProvider dataProviderTestCalc_monthly_costException
     * @expectedException KlarnaException
     * @param int   $sum        The sum for the order/product in �ren/cents
     * @param int   $pclass
     * @param int   $flags      Indicates if it is the checkout or a product page.
     */
    public function testCalc_monthly_costException($sum, $pclass, $flags) {
        $this->assertNull($this->klarnaCalc->calc_monthly_cost($sum, $pclass, $flags));
    }

    public function dataProviderGet_lowest_payment_for_account() {
        return array(
            array(50.0, KlarnaCountry::SE),
            array(95.0, KlarnaCountry::NO),
            array(8.95, KlarnaCountry::FI),
            array(89.0, KlarnaCountry::DK),
            array(6.95, KlarnaCountry::DE),
            array(6.95, KlarnaCountry::NL),
        );
    }

    /**
     * @dataProvider dataProviderGet_lowest_payment_for_account
     * @param   int|float $result
     * @param   int       $country
     * @return  int|float
     */
    public function testGet_lowest_payment_for_account($result, $country) {
        $this->assertEquals($result, $this->klarnaCalc->get_lowest_payment_for_account($country));
    }

    public function dataProviderTesttestGet_lowest_payment_for_accountException() {
        return array(
            array(999),
            array("abc"),
        );
    }

    /**
     * @dataProvider dataProviderTesttestGet_lowest_payment_for_accountException
     * @expectedException KlarnaException
     * @param int   $country
     */
    public function testGet_lowest_payment_for_accountException($country) {
        $this->assertNull($this->klarnaCalc->get_lowest_payment_for_account($country));
    }

    /**
     * @dataProvider jsonRound
     */
    public function testpRound($expected, $value, $country) {
        $this->assertEquals($expected, KlarnaCalc::pRound($value, Klarna::getCountryForCode($country)));
    }

    public function jsonRound() {
        return new JSONFileIterator(dirname(__FILE__).'/data/rounding.json');
    }

}
?>
