<?php
//~ require_once 'vfsStream/vfsStream.php';
require_once(DIR_WS_INCLUDES.'external/klarna/api/klarnapclass.php');
require_once(DIR_WS_INCLUDES.'external/klarna/api/pclasses/jsonstorage.class.php');


/**
 * Test class for JSONStorage.
 *
 * Dependencies:
 * pear channel-discover pear.php-tools.net
 * pear install pat/vfsStream-alpha
 *
 * Generated by PHPUnit on 2011-07-21 at 12:17:26.
 */
class JSONStorageTest extends PHPUnit_Framework_TestCase
{
    /**
     * @var JSONStorage
     */
    protected $object;

    public static function setUpBeforeClass() {
        date_default_timezone_set('Europe/Stockholm');

        vfsStreamWrapper::register();
        vfsStreamWrapper::setRoot(new vfsStreamDirectory('testDir'));
    }

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp()
    {
        $this->uri = vfsStream::url('testDir/pclasses.json');

        $this->object = new JSONStorage();
        $this->expire = strtotime("+1 day" , time());
        $this->pclass = new KlarnaPClass(
            array(
                'eid' => 2,
                'id' => 666,
                'description' => 'desc_pclass',
                'months' => 12,
                'startfee' => 0,
                'invoicefee' => 0,
                'interestrate' => 12.2,
                'minamount' => 1,
                'country' => 81,
                'type' => 2,
                'expire' => $this->expire
            )
        );
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown()
    {
        unlink($this->uri);
    }

    /**
     * @group allPHP
     */
    public function testSave()
    {
        $this->object->addPClass($this->pclass);
        $this->assertFalse(file_exists($this->uri));

        $this->object->save($this->uri);
        $this->assertTrue(file_exists($this->uri));

        $tmp = array();
        $pclassArray = $this->pclass->toArray();
        foreach($pclassArray as $key => $val) {
            if(is_string($val)) {
                $val = '"'.$val.'"';
            }
            $tmp[] = '"'.$key.'":'.$val;
        }
        $expected = '{"'.$this->pclass->getEid().'":[{'.implode($tmp, ',').'}]}';

        $this->assertEquals($expected, file_get_contents($this->uri));
    }

    /**
     * @group allPHP
     * @depends testSave
     */
    public function testLoad()
    {
        $this->testSave();

        $this->assertTrue(file_exists($this->uri));
        $this->object->load($this->uri);

        $pclass = $this->object->getPClass($this->pclass->getId(), $this->pclass->getEid(), $this->pclass->getCountry());
        $this->assertEquals($this->pclass, $pclass);
    }

    /**
     * @group allPHP
     * @depends testLoad
     */
    public function testClear()
    {
        $this->testSave();

        $this->assertTrue(file_exists($this->uri));

        $this->object->clear($this->uri);

        $this->assertFalse(file_exists($this->uri));
    }
}
?>
