<?php
//~ require_once 'vfsStream/vfsStream.php';
require_once(DIR_WS_INCLUDES.'external/klarna/api/transport/xmlrpc-3.0.0.beta/lib/xmlrpc.inc');
require_once(DIR_WS_INCLUDES.'external/klarna/api/transport/xmlrpc-3.0.0.beta/lib/xmlrpc_wrappers.inc');
require_once('../Klarna.php');

/**
 * Test class for KlarnaConfig.
 * Generated by PHPUnit on 2011-02-03 at 15:53:37.
 */
class KlarnaConfigTest extends PHPUnit_Framework_TestCase {

    /**
     * @var KlarnaConfig
     */
    protected $klarnaConfig;

    public static function setUpBeforeClass() {
        date_default_timezone_set('Europe/Stockholm');

        vfsStreamWrapper::register();
        vfsStreamWrapper::setRoot(new vfsStreamDirectory('testDir'));
    }

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp() {
        $this->uri = vfsStream::url('testDir/config.json');

        KlarnaConfig::$store = false;
        $this->klarnaConfig = new KlarnaConfig;
        $this->klarnaConfig['eid'] = "1029";
        $this->klarnaConfig['secret'] = "ALSyKSaQupJWAUK";
        $this->klarnaConfig['country'] = KlarnaCountry::SE;
        $this->klarnaConfig['language'] = KlarnaLanguage::SV;
        $this->klarnaConfig['currency'] = KlarnaCurrency::SEK;
        $this->klarnaConfig['mode'] = 1;
        $this->klarnaConfig['ssl'] = true;
        $this->klarnaConfig['candice'] = true;
        $this->klarnaConfig['pcURI'] = dirname(__FILE__) . '/data/beta-pclasses.json';
        $this->klarnaConfig['pcStorage'] = 'json';
        $klarna = new Klarna();
        $klarna->setConfig($this->klarnaConfig);
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown() {
        unset ($this->klarnaConfig);
        unlink($this->uri);
    }

    public function testClear() {
        $this->assertNull($this->klarnaConfig->clear());
    }

    public function testConstructException(){
        KlarnaConfig::$store = true;
        $this->klarnaConfig = new KlarnaConfig("");
    }

    public function dataProviderTestOffsetExists() {
        return array(
            array("eid"),
            array("secret"),
            array("country"),
            array("language"),
            array("currency"),
            array("mode"),
            array("ssl"),
            array("candice"),
            array("pcStorage"),
            array("pcURI"),
        );
    }

    /**
     * @dataProvider dataProviderTestOffsetExists
     * @param string $offset
     */
    public function testOffsetExists($offset) {
        $this->assertTrue($this->klarnaConfig->offsetExists($offset));
    }

    public function testOffsetExistsFalse() {
        $this->assertFalse($this->klarnaConfig->offsetExists("offset"));
    }

    public function dataProviderTestOffsetGet() {
        return array(
            array("1029", "eid"),
            array("ALSyKSaQupJWAUK", "secret"),
            array(KlarnaCountry::SE, "country"),
            array(KlarnaLanguage::SV, "language"),
            array(KlarnaCurrency::SEK, "currency"),
            array(1, "mode"),
            array(true, "ssl"),
            array(true, "candice"),
            array("json", "pcStorage"),
            array(dirname(__FILE__) . '/data/beta-pclasses.json', "pcURI"),
        );
    }

    /**
     * @dataProvider dataProviderTestOffsetGet
     * @param string $result
     * @param string $offset
     */
    public function testOffsetGet($result, $offset) {
        $this->assertEquals($result, $this->klarnaConfig->offsetGet($offset));
    }

    public function testOffsetGetFalse() {
        $this->assertNull($this->klarnaConfig->offsetGet("offset"));
    }

    public function dataProviderTestOffsetSet() {
        return array(
            array("eid", "1004"),
            array("secret", "D3FsZBljLfSZoq9"),
            array("country", KlarnaCountry::SE),
            array("language", KlarnaLanguage::SV),
            array("currency", KlarnaCurrency::SEK),
            array("mode", 0),
            array("mode", 1),
            array("ssl", false),
            array("ssl", true),
            array("candice", false),
            array("candice", true),
            array("pcStorage", "json"),
            array("pcStorage", "xml"),
            array("pcStorage", "mysql"),
            array("pcURI", "pcURI.pcURI"),
        );
    }

    /**
     * @dataProvider dataProviderTestOffsetSet
     * @param string $offset
     * @param string $value
     */
    public function testOffsetSet($offset, $value) {
        $this->assertNull($this->klarnaConfig->offsetSet($offset, $value));
    }

    public function dataProviderTestOffsetUnset() {
        return array(
            array("eid"),
            array("secret"),
            array("country"),
            array("language"),
            array("currency"),
            array("mode"),
            array("ssl"),
            array("candice"),
            array("pcStorage"),
            array("pcURI"),
        );
    }

    /**
     * @dataProvider dataProviderTestOffsetUnset
     * @param string $offset
     */
    public function testOffsetUnset($offset) {
        $this->klarnaConfig->offsetUnset($offset);
    }

    public function testLoadConfigFile() {
        KlarnaConfig::$store = true;
        $c = new KlarnaConfig($this->uri);
        $c['testing'] = 123;
        $c->__destruct();

        $c = new KlarnaConfig($this->uri);
        $this->assertEquals($c['testing'], 123);
    }

}
?>
